/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RBFKernel
extends CachedKernel {
    static final long serialVersionUID = 5247117544316387852L;
    protected double[] m_kernelPrecalc;
    protected double m_gamma = 0.01;

    public RBFKernel() {
    }

    public RBFKernel(Instances data, int cacheSize, double gamma) throws Exception {
        this.setCacheSize(cacheSize);
        this.setGamma(gamma);
        this.buildKernel(data);
    }

    @Override
    public String globalInfo() {
        return "The RBF kernel. K(x, y) = e^-(gamma * <x-y, x-y>^2)";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe Gamma parameter.\n\t(default: 0.01)", "G", 1, "-G <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('G', options);
        if (tmpStr.length() != 0) {
            this.setGamma(Double.parseDouble(tmpStr));
        } else {
            this.setGamma(0.01);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-G");
        result.add("" + this.getGamma());
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        if (id1 == id2) {
            return 1.0;
        }
        double precalc1 = id1 == -1 ? this.dotProd(inst1, inst1) : this.m_kernelPrecalc[id1];
        Instance inst2 = this.m_data.instance(id2);
        double result = Math.exp(this.m_gamma * (2.0 * this.dotProd(inst1, inst2) - precalc1 - this.m_kernelPrecalc[id2]));
        return result;
    }

    public void setGamma(double value) {
        this.m_gamma = value;
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public String gammaTipText() {
        return "The Gamma value.";
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        this.m_kernelPrecalc = new double[data.numInstances()];
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(data);
        }
        this.initVars(data);
        int i = 0;
        while (i < data.numInstances()) {
            this.m_kernelPrecalc[i] = this.dotProd(data.instance(i), data.instance(i));
            ++i;
        }
    }

    public String toString() {
        return "RBF kernel: K(x,y) = e^-(" + this.getGamma() + "* <x-y,x-y>^2)";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

